<?php
// 设置时区为中国时间
date_default_timezone_set('Asia/Shanghai');

// 禁止显示警告和通知
error_reporting(E_ERROR | E_PARSE);

// 检查并创建目录
function ensureDirectoryExists($dir) {
    if (!is_dir($dir)) {
        mkdir($dir, 0777, true);
    }
}

// 清空指定目录
function clearDirectory($dir) {
    if (is_dir($dir)) {
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            $path = "$dir/$file";
            if (is_dir($path)) {
                clearDirectory($path);
                rmdir($path);
            } else {
                unlink($path);
            }
        }
    }
}

// 生成基于当前中国时间的文件名，并加上前缀
function generateTimestampFilename($prefix = 'i2578') {
    return $prefix . '_' . date('YmdHis') . '.zip';
}

// 初始化ZIP对象
function createZipArchive($source, $destination) {
    if (!extension_loaded('zip') || !file_exists($source)) {
        return false;
    }

    $zip = new ZipArchive();
    if (!$zip->open($destination, ZipArchive::CREATE)) {
        return false;
    }

    $source = str_replace('\\', '/', $source); // 直接使用传递的路径

    if (is_dir($source) === true) {
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($source, RecursiveDirectoryIterator::SKIP_DOTS), 
            RecursiveIteratorIterator::SELF_FIRST
        );

        foreach ($files as $file) {
            $file = str_replace('\\', '/', $file); // 直接使用传递的路径

            if (strpos($file, $source) !== 0) {
                continue;  // 忽略超出源目录范围的文件
            }

            if (is_dir($file) === true) {
                $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
            } elseif (is_file($file) === true && is_readable($file)) {
                $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
            }
        }
    } elseif (is_file($source) === true && is_readable($source)) {
        $zip->addFromString(basename($source), file_get_contents($source));
    }

    return $zip->close();
}

// 处理ZIP文件的创建和返回下载链接
$ysDir = __DIR__ . '/ys';
ensureDirectoryExists($ysDir); // 确保ys目录存在
clearDirectory($ysDir);

$zipFilename = generateTimestampFilename('mynote'); // 使用前缀"web"
$zipFilePath = $ysDir . '/' . $zipFilename;

if (createZipArchive(__DIR__, $zipFilePath)) {
    $fullUrl = (isset($_SERVER['HTTPS']) ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . '/ys/' . $zipFilename;
    echo "文件已打包成功。点击以下链接下载：<br>";
    echo "<a href='$fullUrl'>下载ZIP文件</a>";
} else {
    echo "打包失败。";
}
?>
